/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.view.Surface;
import java.nio.ByteBuffer;

public class MediaCodec {
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";

    MediaCodec() {
    }

    public static MediaCodec createDecoderByType(String type) {
        throw new RuntimeException("Method createDecoderByType in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public static MediaCodec createEncoderByType(String type) {
        throw new RuntimeException("Method createEncoderByType in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public static MediaCodec createByCodecName(String name) {
        throw new RuntimeException("Method createByCodecName in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    protected void finalize() {
        throw new RuntimeException("Method finalize in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public native void release();

    public void configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        throw new RuntimeException("Method configure in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public native Surface createInputSurface();

    public native void start();

    public native void stop();

    public native void flush();

    public native void queueInputBuffer(int var1, int var2, int var3, long var4, int var6) throws CryptoException;

    public native void queueSecureInputBuffer(int var1, int var2, CryptoInfo var3, long var4, int var6) throws CryptoException;

    public native int dequeueInputBuffer(long var1);

    public native int dequeueOutputBuffer(BufferInfo var1, long var2);

    public native void releaseOutputBuffer(int var1, boolean var2);

    public native void signalEndOfInputStream();

    public MediaFormat getOutputFormat() {
        throw new RuntimeException("Method getOutputFormat in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public ByteBuffer[] getInputBuffers() {
        throw new RuntimeException("Method getInputBuffers in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public ByteBuffer[] getOutputBuffers() {
        throw new RuntimeException("Method getOutputBuffers in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public native void setVideoScalingMode(int var1);

    public native String getName();

    public void setParameters(Bundle params) {
        throw new RuntimeException("Method setParameters in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public MediaCodecInfo getCodecInfo() {
        throw new RuntimeException("Method getCodecInfo in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public static class CryptoInfo {
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;

        public void set(int newNumSubSamples, int[] newNumBytesOfClearData, int[] newNumBytesOfEncryptedData, byte[] newKey, byte[] newIV, int newMode) {
            throw new RuntimeException("Method set in android.media.MediaCodec$CryptoInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public String toString() {
            throw new RuntimeException("Method toString in android.media.MediaCodec$CryptoInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static class CryptoException
    extends RuntimeException {
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;

        public CryptoException(int errorCode, String detailMessage) {
        }

        public int getErrorCode() {
            throw new RuntimeException("Method getErrorCode in android.media.MediaCodec$CryptoException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static class BufferInfo {
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            throw new RuntimeException("Method set in android.media.MediaCodec$BufferInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }
}

